IF OBJECT_ID('P_EST_PROD_CPL_CARGA_CLEANUP') IS NOT NULL
    BEGIN
        DROP PROCEDURE  P_EST_PROD_CPL_CARGA_CLEANUP;
    END;
GO 
CREATE PROCEDURE P_EST_PROD_CPL_CARGA_CLEANUP
AS
BEGIN

    SET NOCOUNT ON;
    DECLARE @CD_FILIAL INT;
    DECLARE @LAST_VERSION INT;

    DECLARE C1 CURSOR
    FOR SELECT 
                B.CD_FILIAL
                , A.LAST_VERSION
        FROM 
                TENTACLE_SYNC_VERSAO A
                INNER JOIN TENTACLE_SYNC_CLIENT B ON A.CLIENT_ID = B.ID
        WHERE A.TABELA = 'EST_PROD_CPL';
    
	OPEN C1;
    FETCH NEXT FROM C1 INTO  @CD_FILIAL, @LAST_VERSION;
    WHILE @@FETCH_STATUS = 0
        BEGIN
            DELETE FROM EST_PROD_CPL_CARGA
            WHERE 
                    CD_FILIAL = @CD_FILIAL
                    AND VERSAO < @LAST_VERSION;
            FETCH NEXT FROM C1 INTO  @CD_FILIAL, @LAST_VERSION;
        END;
    CLOSE C1;
    DEALLOCATE C1;
	-----------------------------------------------------------------------------------------------
    ---APGANDO OS REGISTOS DE FILIAIS QUE NÃO ESTÃO CONFIGURADAS NA CARGA
    DECLARE C1 CURSOR
    FOR SELECT 
                A.CD_FILIAL
        FROM 
                PRC_FILIAL A
        WHERE 
			NOT EXISTS (SELECT  B.CD_FILIAL
							FROM 
									TENTACLE_SYNC_CLIENT B
							WHERE A.CD_EMP = B.CD_EMP
									AND A.CD_FILIAL = B.CD_FILIAL);

    OPEN C1;
    FETCH NEXT FROM C1 INTO  @CD_FILIAL;
    WHILE @@FETCH_STATUS = 0
        BEGIN
            DELETE FROM EST_PROD_CPL_CARGA
            WHERE CD_CTR IN( SELECT TOP 1000  CD_CTR
								FROM  EST_PROD_CPL_CARGA WHERE CD_EMP = 1
															AND CD_FILIAL = @CD_FILIAL
                ORDER BY  VERSAO
            );

            WHILE @@ROWCOUNT > @CD_FILIAL
                BEGIN
                    DELETE FROM EST_PROD_CPL_CARGA
                    WHERE CD_CTR IN( SELECT TOP 1000  CD_CTR 
										FROM  EST_PROD_CPL_CARGA
										WHERE CD_EMP = 1 AND CD_FILIAL = @CD_FILIAL
										ORDER BY  VERSAO );
                END;
            FETCH NEXT FROM C1 INTO @CD_FILIAL;
        END;
    CLOSE C1;
    DEALLOCATE C1;

	-----------------------------------------------------------------------------------------------
    ---APGANDO OS REGISTOS DE FILIAIS QUE ESTÃO INATIVAS NA CARGA
    DECLARE C1 CURSOR
    FOR SELECT 
                B.CD_FILIAL
        FROM 
                TENTACLE_SYNC_CLIENT B
        WHERE B.ATIVO = 0;

    OPEN C1;
    FETCH NEXT FROM C1 INTO  @CD_FILIAL;
    WHILE @@FETCH_STATUS = 0
        BEGIN
            DELETE FROM EST_PROD_CPL_CARGA
            WHERE 
                    CD_CTR IN
            (SELECT TOP 1000  CD_CTR FROM  EST_PROD_CPL_CARGA
					WHERE 
						CD_EMP = 1
                    AND CD_FILIAL = @CD_FILIAL
                ORDER BY VERSAO );

            WHILE @@ROWCOUNT > @CD_FILIAL
                BEGIN
                    DELETE FROM EST_PROD_CPL_CARGA
                    WHERE  CD_CTR IN
                    ( SELECT TOP 1000 
                                CD_CTR
                        FROM  EST_PROD_CPL_CARGA
                        WHERE CD_EMP = 1
                                AND CD_FILIAL = @CD_FILIAL
                        ORDER BY VERSAO);
                END;
            FETCH NEXT FROM C1 INTO  @CD_FILIAL;
        END;
    CLOSE C1;
    DEALLOCATE C1;


END;